/*
 * Decompiled with CFR 0.152.
 */
package csgs.util;

import csgs.Structure;
import csgs.feature.BinaryFeature;
import csgs.feature.Feature;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class Util {
    public static Feature indexToAssignment(int index, List<Integer> var, List<Integer> card, int numberOfVariables, boolean mostSignificantBit) {
        BinaryFeature feature = new BinaryFeature(numberOfVariables);
        double tmp = index;
        if (mostSignificantBit) {
            for (int i = var.size() - 1; i > -1; --i) {
                ((Feature)feature).addVal(var.get(i), (int)tmp % card.get(var.get(i)));
                tmp /= (double)card.get(var.get(i)).intValue();
            }
        } else {
            for (int i = 0; i < var.size(); ++i) {
                ((Feature)feature).addVal(var.get(i), (int)tmp % card.get(var.get(i)));
                tmp /= (double)card.get(var.get(i)).intValue();
            }
        }
        return feature;
    }

    public static Feature indexToAssignment(int index, List<Integer> var, List<Integer> card, int numberOfVariables) {
        return Util.indexToAssignment(index, var, card, numberOfVariables, false);
    }

    public static int assignmentToIndex(Feature assignment, List<Integer> card, boolean mostSignificantBit) {
        int index = 0;
        int i = assignment.getVar().nextSetBit(0);
        while (i >= 0) {
            Integer val = assignment.getVal(i);
            if (val != 0) {
                index = (int)((double)index + (mostSignificantBit ? Math.pow(card.get(i).intValue(), card.size() - i - 1) : Math.pow(card.get(i).intValue(), i)));
            }
            i = assignment.getVar().nextSetBit(i + 1);
        }
        return index;
    }

    public static int assignmentToIndex(Feature assignment, List<Integer> card) {
        return Util.assignmentToIndex(assignment, card, false);
    }

    public static void main(String[] aa) {
        ArrayList<Integer> var = new ArrayList<Integer>();
        ArrayList<Integer> card = new ArrayList<Integer>();
        var.add(0);
        var.add(1);
        var.add(2);
        var.add(3);
        card.add(2);
        card.add(2);
        card.add(2);
        card.add(2);
        int numberOfVariables = card.size();
        for (int i = 0; i < 16; ++i) {
            Feature f1 = Util.indexToAssignment(i, var, card, numberOfVariables, false);
            System.out.println(i + " " + f1 + " " + Util.assignmentToIndex(f1, card, false) + " " + Util.assignmentToIndex(f1, card, true));
            Feature f2 = Util.indexToAssignment(i, var, card, numberOfVariables, true);
            System.out.println("---");
        }
    }

    public static void bronKerboschAlgorithm(Collection<BitSet> cliques, BitSet compsub, BitSet candidates, BitSet not, Structure neighbors) {
        if (candidates.cardinality() == 0 && not.cardinality() == 0) {
            cliques.add(compsub);
            return;
        }
        BitSet nodesToSelect = (BitSet)candidates.clone();
        nodesToSelect.or(not);
        int pivot = nodesToSelect.nextSetBit(0);
        BitSet neighborsOfPivot = neighbors.getAdjacencies(pivot);
        BitSet inspect = (BitSet)candidates.clone();
        int i = neighborsOfPivot.nextSetBit(0);
        while (i >= 0) {
            inspect.set(i, false);
            i = neighborsOfPivot.nextSetBit(i + 1);
        }
        int selectedNode = inspect.nextSetBit(0);
        while (selectedNode >= 0) {
            BitSet newCompsub = (BitSet)compsub.clone();
            newCompsub.set(selectedNode, true);
            BitSet neighborsOfSelected = neighbors.getAdjacencies(selectedNode);
            BitSet newCandidates = (BitSet)candidates.clone();
            newCandidates.and(neighborsOfSelected);
            BitSet newNot = (BitSet)not.clone();
            newNot.and(neighborsOfSelected);
            Util.bronKerboschAlgorithm(cliques, newCompsub, newCandidates, newNot, neighbors);
            candidates.set(selectedNode, false);
            not.set(selectedNode, true);
            selectedNode = inspect.nextSetBit(selectedNode + 1);
        }
    }

    public static Collection<BitSet> factorizeToCompleteSubgraphs(Structure neighbors) {
        HashSet<BitSet> cliques = new HashSet<BitSet>();
        BitSet initialCandidates = new BitSet(neighbors.getNumberOfVariables());
        initialCandidates.set(0, neighbors.getNumberOfVariables(), true);
        Util.bronKerboschAlgorithm(cliques, new BitSet(neighbors.getNumberOfVariables()), initialCandidates, new BitSet(neighbors.getNumberOfVariables()), neighbors);
        return cliques;
    }
}

