/*
 * Decompiled with CFR 0.152.
 */
package csgs.util;

import java.util.BitSet;
import java.util.Iterator;
import java.util.Stack;

public class PowerSet
implements Iterator<BitSet>,
Iterable<BitSet> {
    private int _minSize;
    private int _numberOfBits;
    private final BitSet _set;
    private BitSet _r;
    private Stack<Node> _stack;

    public PowerSet(BitSet set, int minSize) {
        this._set = set;
        this._numberOfBits = set.cardinality();
        this._minSize = minSize;
        this._r = new BitSet(this._numberOfBits);
        this._stack = new Stack();
        Node root = new Node();
        root._r = new BitSet(this._numberOfBits);
        this._stack.push(root);
    }

    private void nextElement() {
        while (!this._stack.empty()) {
            Node childNode;
            boolean newBranch;
            Node node = this._stack.pop();
            node._r.set(node._branch, true);
            int numberOfFree = this._numberOfBits - node._branch + 1;
            int numberOfUnassignedElement = this._minSize - node._level + 1;
            boolean bl = newBranch = numberOfFree - numberOfUnassignedElement > 0;
            if (newBranch) {
                childNode = new Node(node._level, node._branch + 1);
                childNode._r = (BitSet)node._r.clone();
                childNode._r.set(node._branch, false);
                childNode._r.set(childNode._branch, true);
                this._stack.push(childNode);
            }
            if (node._level + 1 == this._minSize) {
                this._r = (BitSet)node._r.clone();
                break;
            }
            childNode = new Node(node._level + 1, node._branch + 1);
            childNode._r = (BitSet)node._r.clone();
            this._stack.push(childNode);
        }
    }

    @Override
    public boolean hasNext() {
        return !this._stack.empty();
    }

    @Override
    public BitSet next() {
        if (this._minSize == 0) {
            this._stack.pop();
        } else {
            this.nextElement();
        }
        BitSet returnSet = new BitSet(this._r.length());
        int ii = 0;
        int i = this._set.nextSetBit(0);
        while (i >= 0) {
            if (this._r.get(ii++)) {
                returnSet.set(i);
            }
            i = this._set.nextSetBit(i + 1);
        }
        return returnSet;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not Supported!");
    }

    @Override
    public Iterator<BitSet> iterator() {
        return this;
    }

    public static void main(String[] args) {
        int n = 10;
        BitSet b = new BitSet(n);
        b.set(0, true);
        b.set(1, true);
        b.set(2, true);
        b.set(3, true);
        b.set(4, true);
        b.set(5, true);
        PowerSet pset = new PowerSet(b, 6);
        System.out.println("Let go baby!");
        for (BitSet s : pset) {
            System.out.println("== " + s);
        }
    }

    class Node {
        public int _level;
        public int _branch;
        public BitSet _r;

        public Node() {
            this._level = 0;
            this._branch = 0;
        }

        public Node(int level, int branch) {
            this._level = level;
            this._branch = branch;
        }

        public String toString() {
            String output = System.identityHashCode(this) + " l:" + this._level + " b:" + this._branch;
            return output;
        }
    }
}

