/*
 * Decompiled with CFR 0.152.
 */
package csgs.util;

import csgs.Structure;
import csgs.adtree.ADNode;
import csgs.dataset.Dataset;
import csgs.dataset.DatasetType;
import csgs.feature.BinaryFeature;
import csgs.feature.Feature;
import csgs.feature.MixedFeature;
import csgs.feature.PositiveFeature;
import csgs.setting.FeatureType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileHandler {
    public static void writeADTree(File outputFile, ADNode adtree) {
        try {
            FileOutputStream fos = new FileOutputStream(outputFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(adtree);
            oos.flush();
            oos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ADNode readADTree(File inputFile) {
        ADNode adtree = null;
        try {
            FileInputStream fis = new FileInputStream(inputFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            adtree = (ADNode)ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return adtree;
    }

    private static void readCSVDataset(File inputFile, Dataset dataset, Integer maximumNumberOfExamples, FeatureType featureType) throws IOException {
        FileReader fileReader = new FileReader(inputFile);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        int numberOfVariables = 0;
        String line = null;
        long count = 0L;
        while ((line = bufferedReader.readLine()) != null) {
            String[] items = line.trim().split(",");
            numberOfVariables = items.length;
            BinaryFeature example = null;
            example = new BinaryFeature(numberOfVariables);
            for (int i = 0; i < numberOfVariables; ++i) {
                ((Feature)example).addVal(i, Integer.parseInt(items[i]));
            }
            dataset.addExample(example);
            if (maximumNumberOfExamples == null || ++count < (long)maximumNumberOfExamples.intValue()) continue;
            break;
        }
        bufferedReader.close();
        dataset.setNumberOfVariables(numberOfVariables);
    }

    private static void readWDataDataset(File inputFile, Dataset dataset, FeatureType featureType) throws IOException {
        FileReader fileReader = new FileReader(inputFile);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        int numberOfVariables = 0;
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            int i;
            String[] parts = line.trim().split("\\|");
            String[] items = parts[1].split(",");
            numberOfVariables = items.length;
            Feature example = null;
            example = featureType == FeatureType.POSITIVE ? new PositiveFeature(numberOfVariables) : (featureType == FeatureType.MIXED ? new MixedFeature(numberOfVariables) : new BinaryFeature(numberOfVariables));
            for (i = 0; i < numberOfVariables; ++i) {
                example.addVal(i, Integer.parseInt(items[i]));
            }
            for (i = 0; i < Integer.parseInt(parts[0]); ++i) {
                dataset.addExample(example);
            }
        }
        bufferedReader.close();
        dataset.setNumberOfVariables(numberOfVariables);
    }

    public static Dataset readDataset(File inputFile, int maximumNumberOfFeatures, DatasetType datasetType, FeatureType featureType) {
        Dataset dataset = new Dataset(maximumNumberOfFeatures);
        try {
            switch (datasetType) {
                case WDATA: {
                    FileHandler.readWDataDataset(inputFile, dataset, featureType);
                    break;
                }
                case CSV: {
                    FileHandler.readCSVDataset(inputFile, dataset, null, featureType);
                    break;
                }
                default: {
                    FileHandler.readCSVDataset(inputFile, dataset, maximumNumberOfFeatures, featureType);
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dataset;
    }

    public static Dataset readDataset(File inputFile, int maximumNumberOfFeatures, DatasetType datasetType) {
        return FileHandler.readDataset(inputFile, maximumNumberOfFeatures, datasetType, FeatureType.MIXED);
    }

    public static void createFeatureFile(File featureFile) {
        try {
            FileWriter fileWriter = new FileWriter(featureFile);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeFeature(File featureFile, Collection<Feature> features) {
        try {
            FileWriter fileWriter = new FileWriter(featureFile, true);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            for (Feature feature : features) {
                if (feature.getLength() == 0) continue;
                bufferedWriter.write("0.000 " + feature.toString() + "\n");
            }
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeMessage(File logFile, String message) {
        try {
            FileWriter fileWriter = new FileWriter(logFile, true);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS").format(new Date()) + "\t");
            bufferedWriter.write(message + "\n");
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeNetworks(Map<Structure, List<Feature>> structures, File networkFile) {
        try {
            FileWriter fileWriter = new FileWriter(networkFile);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            StringBuilder strContexts = new StringBuilder();
            for (Map.Entry<Structure, List<Feature>> pair : structures.entrySet()) {
                Structure structure = pair.getKey();
                List<Feature> contexts = pair.getValue();
                bufferedWriter.write(structure.toString());
                strContexts = new StringBuilder();
                for (Feature context : contexts) {
                    strContexts.append(context + ",");
                }
                bufferedWriter.write(strContexts.toString().substring(0, strContexts.toString().length() - 1) + "\n");
            }
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<Structure, List<Feature>> readStructure(File networkFile, FeatureType featureType, int numberOfVariables) {
        HashMap<Structure, List<Feature>> structures = new HashMap<Structure, List<Feature>>();
        try {
            FileReader fileReader = new FileReader(networkFile);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            Structure structure = new Structure(numberOfVariables);
            ArrayList<Feature> contexts = new ArrayList<Feature>();
            int i = 0;
            while (bufferedReader.ready()) {
                String[] contextStrings;
                String line = bufferedReader.readLine();
                if (FileHandler.isAdjacencyVector(line)) {
                    String[] adjacencyVector = line.split("\\s");
                    for (int j = 0; j < adjacencyVector.length; ++j) {
                        if (!adjacencyVector[j].equals("1")) continue;
                        structure.addEdge(i, j);
                    }
                    ++i;
                    continue;
                }
                for (String contextString : contextStrings = line.split(",")) {
                    contexts.add(FileHandler.stringToFeature(contextString, featureType, numberOfVariables));
                }
                structures.put(structure, contexts);
                i = 0;
                structure = new Structure(numberOfVariables);
                contexts = new ArrayList();
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        return structures;
    }

    private static Feature stringToFeature(String line, FeatureType featureType, int numberOfVariables) {
        String[] pairs;
        Feature f = featureType == FeatureType.POSITIVE ? new PositiveFeature(numberOfVariables) : (featureType == FeatureType.MIXED ? new MixedFeature(numberOfVariables) : new BinaryFeature(numberOfVariables));
        for (String pair : pairs = line.substring(2).split("\\+v")) {
            f.addVal(Integer.parseInt(pair.substring(0, 1)), Integer.parseInt(pair.substring(2, 3)));
        }
        return f;
    }

    private static boolean isAdjacencyVector(String line) {
        return line.matches("([0-1\\s])+");
    }

    public static void writeNetwork(int numberOfVariables, File networkFile, Set<Feature> features, FeatureType featureType) {
        try {
            FileWriter fileWriter = new FileWriter(networkFile);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            StringBuilder scheme = new StringBuilder();
            for (int i = 0; i < numberOfVariables; ++i) {
                scheme.append("2,");
            }
            bufferedWriter.write(scheme.toString().substring(0, scheme.toString().length() - 1) + "\n");
            bufferedWriter.write("MN {\n");
            for (Feature feature : features) {
                bufferedWriter.write("0.000 " + feature.toString() + "\n");
            }
            bufferedWriter.write("}\n");
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<Feature> readContexts(File inputFile, FeatureType featureType) throws IOException {
        FileReader fileReader = new FileReader(inputFile);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        ArrayList<Feature> contexts = new ArrayList<Feature>();
        int numberOfVariables = -1;
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            String[] items = line.trim().split(",");
            numberOfVariables = items.length;
            Feature example = null;
            example = featureType == FeatureType.POSITIVE ? new PositiveFeature(numberOfVariables) : (featureType == FeatureType.MIXED ? new MixedFeature(numberOfVariables) : new BinaryFeature(numberOfVariables));
            for (int i = 0; i < numberOfVariables; ++i) {
                example.addVal(i, Integer.parseInt(items[i]));
            }
            contexts.add(example);
        }
        bufferedReader.close();
        return contexts;
    }

    public static Map<Structure, List<Feature>> readNetworks(String strInputFile, int numberOfVariables) throws IOException {
        File inputFile = new File(strInputFile);
        FileReader fileReader = new FileReader(inputFile);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        HashMap<Structure, List<Feature>> structures = new HashMap<Structure, List<Feature>>();
        String line = null;
        int k = 0;
        while ((line = bufferedReader.readLine()) != null) {
            String[] items = line.trim().split(" ");
            Structure structure = new Structure(numberOfVariables);
            for (int j = 1; j < items.length; ++j) {
                if (Integer.parseInt(items[j]) != 1) continue;
                structure.addEdge(0, j);
            }
            for (int i = 1; i < numberOfVariables; ++i) {
                line = bufferedReader.readLine();
                items = line.trim().split(" ");
                for (int j = i + 1; j < items.length; ++j) {
                    if (Integer.parseInt(items[j]) != 1) continue;
                    structure.addEdge(i, j);
                }
            }
            ++k;
            BinaryFeature context = new BinaryFeature(numberOfVariables);
            line = bufferedReader.readLine();
            items = line.trim().split(" ");
            for (int i = 0; i < numberOfVariables; ++i) {
                ((Feature)context).addVal(i, Integer.parseInt(items[i].split("_")[1]));
            }
            List<BinaryFeature> contextsOfStructure = structures.containsKey(structure) ? (List)structures.get(structure) : new ArrayList();
            contextsOfStructure.add(context);
            structures.put(structure, contextsOfStructure);
        }
        bufferedReader.close();
        return structures;
    }

    public static void writeNetwork(Structure structure, Feature context, File networkFile) {
        try {
            if (structure == null && context == null) {
                FileWriter fileWriter = new FileWriter(networkFile);
                return;
            }
            FileWriter fileWriter = new FileWriter(networkFile, true);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(structure.toString());
            bufferedWriter.write(context.toString() + "\n");
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

