/*
 * Decompiled with CFR 0.152.
 */
package csgs.independenceTest;

import csgs.adtree.ADNode;
import csgs.dataset.Dataset;
import csgs.setting.FeatureType;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class IndependenceTest {
    private Dataset _dataset;
    private double _threshold;
    private boolean _truthValue;
    private double _logPValue;
    private ADNode _adTree;
    private int _x;
    private int _y;
    private List<Integer> _z;
    private List<Integer> _context;
    private FeatureType _featureType;

    public IndependenceTest(Dataset data, double threshold) {
        this._dataset = data;
        this._threshold = threshold;
        this._truthValue = false;
        this._logPValue = 0.0;
        this._adTree = null;
        this._x = -1;
        this._y = -1;
        this._z = null;
        this._context = null;
        this._featureType = FeatureType.MIXED;
    }

    public IndependenceTest(Dataset data, double threshold, FeatureType featureType) {
        this(data, threshold);
        this._featureType = featureType;
    }

    public abstract double computeLogPValue(int var1, int var2, List<Integer> var3, List<Integer> var4);

    public boolean independent(int x, int y, List<Integer> z, List<Integer> context) {
        this._x = x;
        this._y = y;
        this._z = new ArrayList<Integer>(z);
        this._context = new ArrayList<Integer>(context);
        this._logPValue = this.computeLogPValue(x, y, z, context);
        this._truthValue = this._logPValue > Math.log(this._threshold);
        return this._truthValue;
    }

    public boolean independent(int x, int y, List<Integer> z) {
        return this.independent(x, y, z, null);
    }

    private int[] computeContingencyTableFromADTree(BitSet vars, Map<Integer, Integer> context) {
        int[] cards = new int[this._dataset.getNumberOfVariables()];
        for (int i = 0; i < cards.length; ++i) {
            cards[i] = this._dataset.getCard(i);
        }
        return this._adTree.makeContab(vars, context, cards, this._dataset);
    }

    public HashMap<Integer, int[][]> computeContingencyTables(int x, int y, List<Integer> z, List<Integer> context) {
        BitSet vars = new BitSet(this._dataset.getNumberOfVariables());
        vars.set(x, true);
        vars.set(y, true);
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < z.size(); ++i) {
            vars.set((int)z.get(i), true);
            map.put(z.get(i), context.get(i));
        }
        int[] counts = this._adTree != null ? this.computeContingencyTableFromADTree(vars, map) : this._dataset.computeSufficientStatistics(vars, map);
        HashMap<Integer, int[][]> contTables = new HashMap<Integer, int[][]>();
        int[][] contTable = new int[this._dataset.getCard(x)][this._dataset.getCard(x)];
        contTable[0][0] = counts[0];
        contTable[0][1] = counts[1];
        contTable[1][0] = counts[2];
        contTable[1][1] = counts[3];
        counts = null;
        contTables.put(0, contTable);
        return contTables;
    }

    public void setADTree(ADNode adtree) {
        this._adTree = adtree;
    }

    public void setThreshold(double threshold) {
        this._threshold = threshold;
    }

    public double getThreshold() {
        return this._threshold;
    }

    public boolean getTruthValue() {
        return this._truthValue;
    }

    public double getPValue() {
        return Math.exp(this._logPValue);
    }

    public Dataset getDataset() {
        return this._dataset;
    }

    public String toString() {
        String output = this.getTruthValue() ? "I" : "!I";
        output = output + " " + this._x + ", " + this._y + " | (";
        for (int i = 0; i < this._z.size(); ++i) {
            output = output + this._z.get(i) + "=";
            if (this._context != null) {
                output = output + this._context.get(i);
            }
            output = output + " ";
        }
        output = output.trim() + ") p-value: " + this.getPValue();
        return output;
    }
}

