/*
 * Decompiled with CFR 0.152.
 */
package csgs.independenceTest;

import csgs.dataset.Dataset;
import csgs.independenceTest.IndependenceTest;
import csgs.setting.FeatureType;
import java.util.HashMap;
import java.util.List;

public class ChiSquare
extends IndependenceTest {
    private static double gamser;
    private static double gammcf;
    private static double gln;
    private static double FPMIN;
    private static int ITMAX;
    private static double EPS;
    private double df;

    public ChiSquare(Dataset data, double threshold) {
        super(data, threshold);
    }

    public ChiSquare(Dataset data, double threshold, FeatureType featureType) {
        super(data, threshold, featureType);
    }

    @Override
    public double computeLogPValue(int x, int y, List<Integer> z, List<Integer> context) {
        HashMap<Integer, int[][]> contTables = this.computeContingencyTables(x, y, z, context);
        long numValX = this.getDataset().getCard(x);
        long numValY = this.getDataset().getCard(y);
        int numSlices = contTables.size();
        this.df = (numValX * numValY - 1L) * (long)numSlices;
        double chsq = 0.0;
        for (int[][] ct : contTables.values()) {
            chsq += this.chiVal(ct);
        }
        double logPValue = chsq == 0.0 ? 0.0 : ChiSquare.ln_gammq(0.5 * this.df, 0.5 * chsq);
        return logPValue;
    }

    protected double chiVal(int[][] matrix) {
        int col;
        int row;
        double expect = 0.0;
        double chival = 0.0;
        double n = 0.0;
        int nrows = matrix.length;
        int ncols = matrix[0].length;
        double[] rtotal = new double[nrows];
        double[] ctotal = new double[ncols];
        for (row = 0; row < nrows; ++row) {
            for (col = 0; col < ncols; ++col) {
                int n2 = row;
                rtotal[n2] = rtotal[n2] + (double)matrix[row][col];
                int n3 = col;
                ctotal[n3] = ctotal[n3] + (double)matrix[row][col];
                n += (double)matrix[row][col];
            }
        }
        chival = 0.0;
        for (row = 0; row < nrows; ++row) {
            for (col = 0; col < ncols; ++col) {
                if (ctotal[col] == 0.0 || rtotal[row] == 0.0) {
                    this.df -= 1.0;
                    continue;
                }
                expect = ctotal[col] * rtotal[row] / n;
                if (expect == 0.0) continue;
                chival += this.computeCell(matrix[row][col], expect);
            }
        }
        return chival;
    }

    protected double computeCell(double Oij, double Eij) {
        return Math.abs(Oij - Eij) * Math.abs(Oij - Eij) / Eij;
    }

    public static double gammq(double df, double x) {
        if (x < 0.0 || df <= 0.0) {
            System.err.println("Invalid arguments in routine gammq()");
            new Exception().printStackTrace();
            System.exit(0);
        }
        if (x < df + 1.0) {
            if (x == 0.0) {
                return 1.0;
            }
            ChiSquare.gser(df, x);
            return 1.0 - gamser;
        }
        ChiSquare.gcf(df, x);
        return gammcf;
    }

    static void gser(double df, double x) {
        double sum;
        gln = ChiSquare.gammln(df);
        if (x < 0.0) {
            System.err.println("x less than 0 in routine gser()");
            return;
        }
        double ap = df;
        double del = sum = 1.0 / df;
        for (int n = 1; n <= ITMAX; ++n) {
            sum += (del *= x / (ap += 1.0));
            if (!(Math.abs(del) < Math.abs(sum) * EPS)) continue;
            gamser = sum * Math.exp(-x + df * Math.log(x) - gln);
            return;
        }
        System.err.println("a too large, ITMAX too small in routine gser()");
    }

    static void gcf(double a, double x) {
        int i;
        double d;
        gln = ChiSquare.gammln(a);
        double b = x + 1.0 - a;
        double c = 1.0 / FPMIN;
        double h = d = 1.0 / b;
        for (i = 1; i <= ITMAX; ++i) {
            double an = (double)(-i) * ((double)i - a);
            if (Math.abs(d = an * d + (b += 2.0)) < FPMIN) {
                d = FPMIN;
            }
            if (Math.abs(c = b + an / c) < FPMIN) {
                c = FPMIN;
            }
            d = 1.0 / d;
            double del = d * c;
            h *= del;
            if (Math.abs(del - 1.0) < EPS) break;
        }
        if (i > ITMAX) {
            System.err.println("a too large, ITMAX too small in gcf()");
        }
        gammcf = Math.exp(-x + a * Math.log(x) - gln) * h;
    }

    static double gammln(double xx) {
        double x;
        double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double y = x = xx;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double ser = 1.000000000190015;
        for (int j = 0; j <= 5; ++j) {
            ser += cof[j] / (y += 1.0);
        }
        return -tmp + Math.log(2.5066282746310007 * ser / x);
    }

    public static double ln_gammq(double df, double x) {
        if (x < 0.0 || df <= 0.0) {
            System.err.println("Invalid arguments in routine gammq()");
        }
        if (x < df + 1.0) {
            if (x == 0.0) {
                return 0.0;
            }
            return Math.log(-Math.expm1(ChiSquare.ln_gser(df, x)));
        }
        return ChiSquare.ln_gcf(df, x);
    }

    static double ln_gser(double df, double x) {
        double sum;
        gln = ChiSquare.gammln(df);
        if (x < 0.0) {
            System.err.println("x less than 0 in routine gser()");
            return -1.0;
        }
        double ap = df;
        double del = sum = 1.0 / df;
        for (int n = 1; n <= ITMAX; ++n) {
            sum += (del *= x / (ap += 1.0));
            if (!(Math.abs(del) < Math.abs(sum) * EPS)) continue;
            return Math.log(sum) - x + df * Math.log(x) - gln;
        }
        System.err.println("a too large, ITMAX too small in routine gser()");
        return -1.0;
    }

    static double ln_gcf(double a, double x) {
        int i;
        double d;
        gln = ChiSquare.gammln(a);
        double b = x + 1.0 - a;
        double c = 1.0 / FPMIN;
        double h = d = 1.0 / b;
        for (i = 1; i <= ITMAX; ++i) {
            double an = (double)(-i) * ((double)i - a);
            if (Math.abs(d = an * d + (b += 2.0)) < FPMIN) {
                d = FPMIN;
            }
            if (Math.abs(c = b + an / c) < FPMIN) {
                c = FPMIN;
            }
            d = 1.0 / d;
            double del = d * c;
            h *= del;
            if (Math.abs(del - 1.0) < EPS) break;
        }
        if (i > ITMAX) {
            System.err.println("a too large, ITMAX too small in gcf()");
        }
        return -x + a * Math.log(x) - gln + Math.log(h);
    }

    static {
        FPMIN = 1.0E-30;
        ITMAX = 2000;
        EPS = 3.0E-7;
    }
}

