/*
 * Decompiled with CFR 0.152.
 */
package csgs.generator;

import csgs.Structure;
import csgs.dataset.Dataset;
import csgs.feature.BinaryFeature;
import csgs.feature.Feature;
import csgs.feature.PositiveFeature;
import csgs.setting.FeatureType;
import csgs.util.FileHandler;
import csgs.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class FeatureGenerator {
    public static void main(String[] args) {
        try {
            Collection<Feature> features;
            int numberOfVariables = Integer.parseInt(args[1]);
            Map<Structure, List<Feature>> structures = FileHandler.readNetworks(args[0], numberOfVariables);
            File featureFile = new File(args[2]);
            FeatureType featureType = FeatureType.BINARY;
            if (args.length > 3 && args[3].equals("positive")) {
                featureType = FeatureType.POSITIVE;
            }
            FileHandler.createFeatureFile(featureFile);
            for (Map.Entry<Structure, List<Feature>> pair : structures.entrySet()) {
                Structure structure = pair.getKey();
                List<Feature> structureContexts = pair.getValue();
                for (Feature f : structureContexts) {
                    features = FeatureGenerator.generateFromStructure(f, structure, featureType);
                    FileHandler.writeFeature(featureFile, features);
                }
            }
            features = FeatureGenerator.generateUnitaryFeatures(numberOfVariables, featureType);
            FileHandler.writeFeature(featureFile, features);
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<Feature> generateFromDataset(Dataset dataset, FeatureType featureType) {
        return new ArrayList<Feature>(dataset.getUniqueFeatures());
    }

    public static Collection<Feature> generateFromStructure(Feature context, Structure structure, FeatureType featureType) {
        LinkedHashSet<Feature> features = new LinkedHashSet<Feature>();
        Collection<BitSet> cliques = Util.factorizeToCompleteSubgraphs(structure);
        for (BitSet clique : cliques) {
            Feature feature = featureType == FeatureType.BINARY ? new BinaryFeature(structure.getNumberOfVariables()) : new PositiveFeature(structure.getNumberOfVariables());
            int var = clique.nextSetBit(0);
            while (var >= 0) {
                feature.addVal(var, context.getVal(var));
                var = clique.nextSetBit(var + 1);
            }
            features.add(feature);
        }
        return features;
    }

    public static Collection<Feature> generateUnitaryFeatures(int numberOfVariables) {
        return FeatureGenerator.generateUnitaryFeatures(numberOfVariables, FeatureType.BINARY);
    }

    public static Collection<Feature> generateUnitaryFeatures(int numberOfVariables, FeatureType featureType) {
        LinkedHashSet<Feature> features = new LinkedHashSet<Feature>();
        for (int var = 0; var < numberOfVariables; ++var) {
            for (int value = 0; value < 2; ++value) {
                Feature unitaryFeature = featureType == FeatureType.BINARY ? new BinaryFeature(numberOfVariables) : new PositiveFeature(numberOfVariables);
                unitaryFeature.addVal(var, value);
                features.add(unitaryFeature);
            }
        }
        return features;
    }
}

