/*
 * Decompiled with CFR 0.152.
 */
package csgs.feature;

import csgs.feature.Feature;
import java.util.BitSet;

public class PositiveFeature
extends Feature {
    public PositiveFeature(int n) {
        super(n);
    }

    protected PositiveFeature(int n, BitSet var) {
        super(n, var);
    }

    @Override
    public boolean isSatisfied(Feature otherFeature) {
        int i = this.getVar().nextSetBit(0);
        while (i >= 0) {
            if (!otherFeature.getVar().get(i)) {
                return false;
            }
            i = this.getVar().nextSetBit(i + 1);
        }
        return true;
    }

    @Override
    public void addVal(int var, Integer val) {
        if (val == null || val == 0) {
            this.rmVar(var);
            return;
        }
        this.addVar(var);
    }

    @Override
    public Integer getVal(int var) {
        return this.getVar().get(var) ? 1 : 0;
    }

    @Override
    public int getLength() {
        return this.getVar().cardinality();
    }

    @Override
    public PositiveFeature clone() {
        return new PositiveFeature(this.getNumberOfDomainVariables(), (BitSet)this.getVar().clone());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof PositiveFeature) {
            PositiveFeature f = (PositiveFeature)object;
            return this.getVar().equals(f.getVar());
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int i = this.getVar().nextSetBit(0);
        while (i >= 0) {
            stringBuilder.append("+v" + i + "_1 ");
            i = this.getVar().nextSetBit(i + 1);
        }
        return stringBuilder.toString().trim();
    }
}

