/*
 * Decompiled with CFR 0.152.
 */
package csgs.feature;

import csgs.feature.Feature;
import java.util.Arrays;
import java.util.BitSet;

public class MixedFeature
extends Feature {
    private final BitSet[] _val;

    public MixedFeature(int n) {
        super(n);
        this._val = new BitSet[n];
    }

    public MixedFeature(MixedFeature f) {
        super(f.getNumberOfDomainVariables(), f.getVar());
        this._val = new BitSet[this.getNumberOfDomainVariables()];
        int i = this.getVar().nextSetBit(0);
        while (i >= 0) {
            this.addVal(i, f.getVal(i));
            i = this.getVar().nextSetBit(i + 1);
        }
    }

    @Override
    public boolean isSatisfied(Feature otherFeature) {
        int i = this.getVar().nextSetBit(0);
        while (i >= 0) {
            if (!otherFeature.getVar().get(i)) {
                return false;
            }
            if (this.getVal(i) != otherFeature.getVal(i)) {
                return false;
            }
            i = this.getVar().nextSetBit(i + 1);
        }
        return true;
    }

    @Override
    public void addVal(int var, Integer val) {
        if (val == null) {
            this.rmVar(var);
            this._val[var] = null;
            return;
        }
        this.addVar(var);
        if (this._val[var] == null) {
            this._val[var] = new BitSet();
        } else {
            this._val[var].clear();
        }
        this._val[var].set(val);
    }

    @Override
    public Integer getVal(int var) {
        if (this._val[var] != null) {
            return this._val[var].nextSetBit(0);
        }
        return null;
    }

    @Override
    public int getLength() {
        int count = 0;
        for (int i = 0; i < this._val.length; ++i) {
            if (this._val[i] == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public MixedFeature clone() {
        return new MixedFeature(this);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 67 * hash + (this._val == null ? 0 : Arrays.deepHashCode(this._val));
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MixedFeature other = (MixedFeature)obj;
        return Arrays.deepEquals(this._val, other._val);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int i = this.getVar().nextSetBit(0);
        while (i >= 0) {
            stringBuilder.append("+v" + i + "_" + this.getVal(i) + " ");
            i = this.getVar().nextSetBit(i + 1);
        }
        return stringBuilder.toString().trim();
    }

    public static void main(String[] args) {
        MixedFeature f = new MixedFeature(3);
        ((Feature)f).addVal(0, 1);
        ((Feature)f).addVal(2, 0);
        System.out.println(f);
        System.out.println(((Feature)f).getLength());
        System.out.println(((Feature)f).hashCode());
        ((Feature)f).addVal(1, 2);
        System.out.println(f);
        System.out.println(((Feature)f).getLength());
        System.out.println(((Feature)f).hashCode());
        ((Feature)f).addVal(1, null);
        System.out.println(f);
        System.out.println(((Feature)f).getLength());
        System.out.println(((Feature)f).hashCode());
    }
}

