/*
 * Decompiled with CFR 0.152.
 */
package csgs.feature;

import java.util.BitSet;

public abstract class Feature {
    private final BitSet _var;
    private final int _numberOfDomainVariables;

    public Feature(int n) {
        this._numberOfDomainVariables = n;
        this._var = new BitSet(n);
    }

    protected Feature(int n, BitSet var) {
        this._numberOfDomainVariables = n;
        this._var = (BitSet)var.clone();
    }

    public BitSet getVar() {
        return this._var;
    }

    public void addVar(int var) {
        this._var.set(var);
    }

    public void rmVar(int var) {
        this._var.clear(var);
    }

    protected int getNumberOfDomainVariables() {
        return this._numberOfDomainVariables;
    }

    public abstract boolean isSatisfied(Feature var1);

    public abstract void addVal(int var1, Integer var2);

    public abstract Integer getVal(int var1);

    public abstract int getLength();

    public abstract Feature clone();

    public abstract boolean equals(Object var1);

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this._var == null ? 0 : this._var.hashCode());
        return hash;
    }
}

