/*
 * Decompiled with CFR 0.152.
 */
package csgs.feature;

import csgs.feature.Feature;
import java.util.BitSet;

public class BinaryFeature
extends Feature {
    private final BitSet _val;

    public BinaryFeature(int n) {
        super(n);
        this._val = new BitSet(n);
    }

    public BinaryFeature(BinaryFeature f) {
        super(f.getNumberOfDomainVariables(), f.getVar());
        this._val = new BitSet(f.getNumberOfDomainVariables());
        int i = f._val.nextSetBit(0);
        while (i >= 0) {
            this.addVal(i, 1);
            i = f._val.nextSetBit(i + 1);
        }
    }

    @Override
    public boolean isSatisfied(Feature otherFeature) {
        int i = this.getVar().nextSetBit(0);
        while (i >= 0) {
            if (!otherFeature.getVar().get(i)) {
                return false;
            }
            if (this.getVal(i) != otherFeature.getVal(i)) {
                return false;
            }
            i = this.getVar().nextSetBit(i + 1);
        }
        return true;
    }

    @Override
    public void addVal(int var, Integer val) {
        if (val == null) {
            this._val.set(var, false);
            this.rmVar(var);
            return;
        }
        this.addVar(var);
        if (val == 0) {
            this._val.set(var, false);
        } else {
            this._val.set(var, true);
        }
    }

    @Override
    public Integer getVal(int var) {
        return this._val.get(var) ? 1 : 0;
    }

    @Override
    public int getLength() {
        return this.getVar().cardinality();
    }

    @Override
    public BinaryFeature clone() {
        return new BinaryFeature(this);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 23 * hash + (this._val == null ? 0 : this._val.hashCode());
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryFeature other = (BinaryFeature)obj;
        return this.getVar().equals(other.getVar()) && this._val.equals(other._val);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int i = this.getVar().nextSetBit(0);
        while (i >= 0) {
            stringBuilder.append("+v" + i + "_" + this.getVal(i) + " ");
            i = this.getVar().nextSetBit(i + 1);
        }
        return stringBuilder.toString().trim();
    }

    public static void main(String[] args) {
        BinaryFeature f = new BinaryFeature(4);
        BinaryFeature g = new BinaryFeature(4);
        ((Feature)f).addVal(0, 1);
        ((Feature)f).addVal(1, 0);
        ((Feature)f).addVal(2, 0);
        ((Feature)f).addVal(3, 0);
        ((Feature)g).addVal(1, 1);
        ((Feature)g).addVal(3, 1);
        System.out.println("g: " + ((Feature)g).hashCode() + " f : " + ((Feature)f).hashCode());
    }
}

