/*
 * Decompiled with CFR 0.152.
 */
package csgs.dataset;

import csgs.feature.Feature;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Dataset {
    private final List<Feature> _list;
    private final Map<Feature, Integer> _map;
    private int _numberOfVariables;
    private List<Integer> _card;

    public Dataset(int maximumNumberOfFeatures) {
        this._list = new ArrayList<Feature>(maximumNumberOfFeatures);
        this._card = new ArrayList<Integer>();
        this._numberOfVariables = 0;
        this._map = new HashMap<Feature, Integer>();
    }

    public void addExample(Feature example) {
        Integer value = this._map.get(example);
        if (value == null) {
            this._map.put(example, 1);
            this.getList().add(example);
        } else {
            this._map.put(example, value + 1);
        }
    }

    public int getCount(Feature example) {
        Integer count = this._map.get(example);
        return count == null ? 0 : count;
    }

    public int getCountFromIndex(int index) {
        return this.getCount(this._list.get(index));
    }

    public List<Feature> getUniqueFeatures() {
        Set<Feature> setOfFeatures = this._map.keySet();
        ArrayList<Feature> uniqueFeatures = new ArrayList<Feature>(setOfFeatures.size());
        for (Feature feature : setOfFeatures) {
            uniqueFeatures.add(feature.clone());
        }
        return uniqueFeatures;
    }

    public Feature getExample(int index) {
        return this.getList().get(index).clone();
    }

    public List<Feature> getElements() {
        return Collections.unmodifiableList(this.getList());
    }

    public List<Feature> getList() {
        return this._list;
    }

    public int getNumberOfVariables() {
        return this._numberOfVariables;
    }

    public void setNumberOfVariables(int numberOfVariables) {
        this._numberOfVariables = numberOfVariables;
    }

    public void setCard(List<Integer> card) {
        this._card = card;
    }

    public int getCard(int var) {
        return this._card.get(var);
    }

    public List<Integer> getCard() {
        return Collections.unmodifiableList(this._card);
    }

    public Map<Feature, Integer> getMap() {
        return this._map;
    }

    public int getNumberOfMatchingDataPoints(Feature f) {
        int count = 0;
        for (Feature feature : this._list) {
            if (!f.isSatisfied(feature)) continue;
            ++count;
        }
        return count;
    }

    public int[] computeSufficientStatistics(BitSet vars, Map<Integer, Integer> context) {
        BitSet valuedVars = new BitSet(this.getNumberOfVariables());
        BitSet nonValuedVars = new BitSet(this.getNumberOfVariables());
        int numberOfCells = 1;
        int i = vars.nextSetBit(0);
        while (i >= 0) {
            if (context.containsKey(i)) {
                valuedVars.set(i, true);
            } else {
                nonValuedVars.set(i, true);
                numberOfCells *= this.getCard(i);
            }
            i = vars.nextSetBit(i + 1);
        }
        int[] counts = new int[numberOfCells];
        boolean index = false;
        for (Feature example : this._list) {
            int val;
            int idx = 0;
            int k = 0;
            boolean flag = true;
            int i2 = valuedVars.nextSetBit(0);
            while (i2 >= 0) {
                val = example.getVal(i2);
                if (context.containsKey(i2) && context.get(i2) != val) {
                    flag = false;
                }
                i2 = valuedVars.nextSetBit(i2 + 1);
            }
            if (!flag) continue;
            i2 = nonValuedVars.nextSetBit(0);
            while (i2 >= 0) {
                val = example.getVal(i2);
                if (val != 0) {
                    idx += (int)Math.pow(2.0, nonValuedVars.cardinality() - 1 - k);
                }
                ++k;
                i2 = nonValuedVars.nextSetBit(i2 + 1);
            }
            int n = idx;
            counts[n] = counts[n] + this.getCount(example);
        }
        return counts;
    }

    public int[] computeSufficientStatistics(BitSet vars, Map<Integer, Integer> context, BitSet records) {
        BitSet valuedVars = new BitSet(this.getNumberOfVariables());
        BitSet nonValuedVars = new BitSet(this.getNumberOfVariables());
        int numberOfCells = 1;
        int i = vars.nextSetBit(0);
        while (i >= 0) {
            if (context.containsKey(i)) {
                valuedVars.set(i, true);
            } else {
                nonValuedVars.set(i, true);
                numberOfCells *= this.getCard(i);
            }
            i = vars.nextSetBit(i + 1);
        }
        int[] counts = new int[numberOfCells];
        boolean index = false;
        int j = records.nextSetBit(0);
        while (j >= 0) {
            int val;
            Feature example = this._list.get(j);
            int idx = 0;
            int k = 0;
            boolean flag = true;
            int i2 = valuedVars.nextSetBit(0);
            while (i2 >= 0) {
                val = example.getVal(i2);
                if (context.containsKey(i2) && context.get(i2) != val) {
                    flag = false;
                }
                i2 = valuedVars.nextSetBit(i2 + 1);
            }
            if (flag) {
                i2 = nonValuedVars.nextSetBit(0);
                while (i2 >= 0) {
                    val = example.getVal(i2);
                    if (val != 0) {
                        idx += (int)Math.pow(2.0, nonValuedVars.cardinality() - 1 - k);
                    }
                    ++k;
                    i2 = nonValuedVars.nextSetBit(i2 + 1);
                }
                int n = idx;
                counts[n] = counts[n] + this.getCount(example);
            }
            j = records.nextSetBit(j + 1);
        }
        return counts;
    }
}

