/*
 * Decompiled with CFR 0.152.
 */
package csgs.adtree;

import csgs.adtree.VaryNode;
import csgs.dataset.Dataset;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Map;

public class ADNode
implements Serializable {
    public static int MIN_RECORD_SIZE = 16;
    public VaryNode[] m_VaryNodes;
    public BitSet m_Instances;
    public int m_nCount;
    public int m_nStartNode;

    public static VaryNode makeVaryNode(int iNode, BitSet nRecords, Dataset dataset) {
        int iChild;
        VaryNode _VaryNode = new VaryNode(iNode);
        int nValues = dataset.getCard(iNode);
        BitSet[] nChildRecords = new BitSet[nValues];
        for (int iChild2 = 0; iChild2 < nValues; ++iChild2) {
            nChildRecords[iChild2] = new BitSet();
        }
        int iInstance = nRecords.nextSetBit(0);
        while (iInstance >= 0) {
            nChildRecords[dataset.getList().get(iInstance).getVal(iNode)].set(iInstance);
            iInstance = nRecords.nextSetBit(iInstance + 1);
        }
        int nCount = nChildRecords[0].cardinality();
        int nMCV = 0;
        for (iChild = 1; iChild < nValues; ++iChild) {
            if (nChildRecords[iChild].cardinality() <= nCount) continue;
            nCount = nChildRecords[iChild].cardinality();
            nMCV = iChild;
        }
        _VaryNode.m_nMCV = nMCV;
        nChildRecords[nMCV] = null;
        _VaryNode.m_ADNodes = new ADNode[nValues];
        for (iChild = 0; iChild < nValues; ++iChild) {
            _VaryNode.m_ADNodes[iChild] = iChild == nMCV || nChildRecords[iChild].cardinality() == 0 ? null : ADNode.makeADNode(iNode + 1, nChildRecords[iChild], dataset);
        }
        return _VaryNode;
    }

    private static int computeCount(BitSet nRecords, Dataset dataset) {
        int count = 0;
        int i = nRecords.nextSetBit(0);
        while (i >= 0) {
            count += dataset.getCountFromIndex(i);
            i = nRecords.nextSetBit(i + 1);
        }
        return count;
    }

    public static ADNode makeADNode(int iNode, BitSet nRecords, Dataset dataset) {
        ADNode _ADNode = new ADNode();
        _ADNode.m_nStartNode = iNode;
        _ADNode.m_nCount = ADNode.computeCount(nRecords, dataset);
        _ADNode.m_Instances = (BitSet)nRecords.clone();
        return _ADNode;
    }

    public static ADNode makeADNode(Dataset dataset) {
        BitSet nRecords = new BitSet(dataset.getList().size());
        for (int i = 0; i < dataset.getList().size(); ++i) {
            nRecords.set(i, true);
        }
        return ADNode.makeADNode(0, nRecords, dataset);
    }

    public int[] makeContab(BitSet vars, ADNode node, Map<Integer, Integer> context, int[] cards, Dataset dataset) {
        VaryNode vn;
        if (vars.cardinality() == 0) {
            int[] nArray;
            if (node == null) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = node.m_nCount;
            }
            return nArray;
        }
        int var = vars.nextSetBit(0);
        Integer val = context.get(var);
        if (node == null) {
            int[] nArray;
            if (val == null) {
                nArray = new int[cards[var]];
            } else {
                int[] nArray4 = new int[1];
                nArray = nArray4;
                nArray4[0] = 0;
            }
            return nArray;
        }
        BitSet rvars = (BitSet)vars.clone();
        rvars.set(var, false);
        if (node.m_Instances.cardinality() < MIN_RECORD_SIZE) {
            return dataset.computeSufficientStatistics(vars, context, node.m_Instances);
        }
        if (node.m_VaryNodes == null) {
            node.m_VaryNodes = new VaryNode[dataset.getNumberOfVariables() - node.m_nStartNode];
        }
        if ((vn = node.m_VaryNodes[var - node.m_nStartNode]) == null) {
            node.m_VaryNodes[var - node.m_nStartNode] = vn = ADNode.makeVaryNode(var, node.m_Instances, dataset);
        }
        int mcv = vn.m_nMCV;
        Object ct_k = new int[cards[var]][];
        int numberEl = 1;
        int i = rvars.nextSetBit(0);
        while (i >= 0) {
            if (!context.containsKey(i)) {
                numberEl *= 2;
            }
            i = rvars.nextSetBit(i + 1);
        }
        if (val == null) {
            for (int k = 0; k < cards[var]; ++k) {
                ADNode adnK = k != mcv ? vn.m_ADNodes[k] : node;
                int[] counts = this.makeContab(rvars, adnK, context, cards, dataset);
                if (k != mcv) {
                    ct_k[k] = new int[numberEl];
                }
                if (ct_k[mcv] == null) {
                    ct_k[mcv] = new int[numberEl];
                }
                for (int i2 = 0; i2 < counts.length; ++i2) {
                    int[] nArray = ct_k[k];
                    int n = i2;
                    nArray[n] = nArray[n] + counts[i2];
                    if (k == mcv) continue;
                    int[] nArray5 = ct_k[mcv];
                    int n2 = i2;
                    nArray5[n2] = nArray5[n2] - counts[i2];
                }
                counts = null;
            }
        } else {
            ct_k[val.intValue()] = new int[numberEl];
            for (int k = 0; k < cards[var]; ++k) {
                ADNode adnK = k != mcv ? vn.m_ADNodes[k] : node;
                int[] counts = this.makeContab(rvars, adnK, context, cards, dataset);
                for (int i3 = 0; i3 < counts.length; ++i3) {
                    if (ct_k[k] != null) {
                        int[] nArray = ct_k[k];
                        int n = i3;
                        nArray[n] = nArray[n] + counts[i3];
                    }
                    if (k == mcv || ct_k[mcv] == null) continue;
                    int[] nArray = ct_k[mcv];
                    int n = i3;
                    nArray[n] = nArray[n] - counts[i3];
                }
                counts = null;
            }
            return ct_k[val];
        }
        int[] contingencyTable = new int[numberEl * ((int[][])ct_k).length];
        int offset = 0;
        for (int k = 0; k < ((int[][])ct_k).length; ++k) {
            for (int i4 = 0; i4 < ct_k[k].length; ++i4) {
                contingencyTable[offset + i4] = ct_k[k][i4];
            }
            offset += ct_k[k].length;
        }
        ct_k = null;
        return contingencyTable;
    }

    public int[] makeContab(BitSet vars, Map<Integer, Integer> context, int[] cards, Dataset dataset) {
        return this.makeContab(vars, this, context, cards, dataset);
    }

    public void print() {
        String sTab = new String();
        for (int i = 0; i < this.m_nStartNode; ++i) {
            sTab = sTab + "  ";
        }
        System.out.println(sTab + "Count = " + this.m_nCount);
        if (this.m_VaryNodes != null) {
            for (int iNode = 0; iNode < this.m_VaryNodes.length; ++iNode) {
                System.out.println(sTab + "Node " + (iNode + this.m_nStartNode));
                this.m_VaryNodes[iNode].print(sTab);
            }
        } else {
            System.out.println(this.m_Instances);
        }
    }
}

