/*
 * Decompiled with CFR 0.152.
 */
package csgs;

import csgs.Algorithm;
import csgs.Structure;
import csgs.adtree.ADNode;
import csgs.dataset.Dataset;
import csgs.dataset.DatasetType;
import csgs.feature.Feature;
import csgs.generator.FeatureGenerator;
import csgs.independenceTest.ChiSquare;
import csgs.setting.Configuration;
import csgs.setting.FeatureType;
import csgs.util.FileHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class StructureLearner {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Please provide the path to a configuration file, and a dataset name.");
            System.exit(0);
        }
        try {
            Configuration conf = args.length > 2 ? new Configuration(args[0], args[1], args[2]) : new Configuration(args[0], args[1]);
            Dataset dataset = FileHandler.readDataset(conf.getDatasetFile(), 0, DatasetType.CSV);
            Vector<Integer> card = new Vector<Integer>();
            for (int i = 0; i < dataset.getNumberOfVariables(); ++i) {
                card.add(2);
            }
            dataset.setCard(card);
            ADNode ADTree = null;
            if (conf.getCacheForIndependenceTests()) {
                ADNode.MIN_RECORD_SIZE = conf.getCacheThreshold();
                if (ADNode.MIN_RECORD_SIZE < 0) {
                    ADNode.MIN_RECORD_SIZE = 0;
                }
                if (ADNode.MIN_RECORD_SIZE > dataset.getList().size()) {
                    ADNode.MIN_RECORD_SIZE = dataset.getList().size();
                }
                ADTree = ADNode.makeADNode(dataset);
            }
            ChiSquare test = conf.getIndependenceTestName().contentEquals("chi") ? new ChiSquare(dataset, conf.getIndependenceTestThreshold()) : new ChiSquare(dataset, conf.getIndependenceTestThreshold());
            test.setADTree(ADTree);
            List<Feature> contexts = null;
            if (conf.getSetOfContextsType().contentEquals("dataset")) {
                contexts = FeatureGenerator.generateFromDataset(dataset, FeatureType.BINARY);
            } else {
                if (!conf.getContextsFile().exists()) {
                    System.err.println("file of contexts does not exist.");
                    System.exit(1);
                }
                contexts = FileHandler.readContexts(conf.getContextsFile(), FeatureType.BINARY);
            }
            Algorithm csgs = new Algorithm(dataset.getNumberOfVariables(), test, conf);
            FileHandler.writeNetwork(null, null, conf.getNetworkFile());
            long startTime = System.currentTimeMillis();
            Map<Structure, List<Feature>> structures = csgs.execute(contexts);
            long totalTime = System.currentTimeMillis() - startTime;
            FileHandler.writeMessage(conf.getLogFile(), "Generated " + structures.keySet().size() + " structures for " + contexts.size() + " contexts in " + totalTime + " ms.");
            FileHandler.writeMessage(conf.getLogFile(), "Grow phase - Number of tests:" + csgs.getCountG());
            FileHandler.writeMessage(conf.getLogFile(), "Grow phase - Number of weighted tests:" + csgs.getWcountG());
            FileHandler.writeMessage(conf.getLogFile(), "Shrink phase - Number of tests:" + csgs.getCountS());
            FileHandler.writeMessage(conf.getLogFile(), "Shrink phase - Number of weighted tests:" + csgs.getWcountS());
        }
        catch (FileNotFoundException e) {
            System.out.println("The configuration file was not found.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

