/*
 * Decompiled with CFR 0.152.
 */
package csgs;

import java.util.Arrays;
import java.util.BitSet;

public class Structure {
    private final BitSet[] _adjacencies;

    public Structure(int numberOfVariables) {
        this._adjacencies = new BitSet[numberOfVariables];
        for (int i = 0; i < numberOfVariables; ++i) {
            this._adjacencies[i] = new BitSet(numberOfVariables);
        }
    }

    public Structure(Structure structure) {
        this._adjacencies = new BitSet[structure.getNumberOfVariables()];
        for (int i = 0; i < structure.getNumberOfVariables(); ++i) {
            this._adjacencies[i] = (BitSet)structure.getAdjacencies(i).clone();
        }
    }

    public BitSet getAdjacencies(int variable) {
        return this._adjacencies[variable];
    }

    public void addEdge(int x, int y) {
        if (this._adjacencies[x] == null) {
            this._adjacencies[x] = new BitSet(this.getNumberOfVariables());
        }
        if (this._adjacencies[y] == null) {
            this._adjacencies[y] = new BitSet(this.getNumberOfVariables());
        }
        this._adjacencies[x].set(y, true);
        this._adjacencies[y].set(x, true);
    }

    public void rmEdge(int x, int y) {
        this._adjacencies[x].set(y, false);
        this._adjacencies[y].set(x, false);
    }

    public int getNumberOfVariables() {
        return this._adjacencies.length;
    }

    public Structure clone() {
        return new Structure(this);
    }

    public boolean equals(Object object) {
        if (object instanceof Structure) {
            Structure st = (Structure)object;
            return Arrays.deepEquals(this._adjacencies, st._adjacencies);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.deepHashCode((Object[])this._adjacencies.clone());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            int j;
            for (j = 0; j < this.getNumberOfVariables() - 1; ++j) {
                stringBuilder.append((this._adjacencies[i].get(j) ? 1 : 0) + " ");
            }
            stringBuilder.append((this._adjacencies[i].get(j) ? 1 : 0) + "\n");
        }
        return stringBuilder.toString();
    }
}

