/*
 * Decompiled with CFR 0.152.
 */
package csgs;

import csgs.Structure;
import csgs.feature.Feature;
import csgs.independenceTest.IndependenceTest;
import csgs.setting.Configuration;
import csgs.util.FileHandler;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Algorithm {
    protected final IndependenceTest _independenceTest;
    protected final int _numberOfVariables;
    protected final Configuration _conf;
    protected long _countG;
    protected long _wcountG;
    protected long _countS;
    protected long _wcountS;

    public Algorithm(int numberOfVariables, IndependenceTest independenceTest, Configuration conf) {
        this._independenceTest = independenceTest;
        this._numberOfVariables = numberOfVariables;
        this._conf = conf;
    }

    private Structure csgs(Feature context) {
        Structure structure = new Structure(this._numberOfVariables);
        for (int x = 0; x < this._numberOfVariables; ++x) {
            int i;
            ArrayList<Integer> contextualValues;
            ArrayList<Integer> contextualVariables;
            BitSet blanket = (BitSet)structure.getAdjacencies(x).clone();
            BitSet remainingNodes = (BitSet)blanket.clone();
            remainingNodes.flip(0, this._numberOfVariables);
            int y = remainingNodes.nextSetBit(x + 1);
            while (y >= 0) {
                contextualVariables = new ArrayList<Integer>();
                contextualValues = new ArrayList<Integer>();
                i = blanket.nextSetBit(0);
                while (i >= 0) {
                    contextualVariables.add(i);
                    contextualValues.add(context.getVal(i));
                    i = blanket.nextSetBit(i + 1);
                }
                this._independenceTest.independent(x, y, contextualVariables, contextualValues);
                ++this._countG;
                this._wcountG += (long)(2 + contextualVariables.size());
                if (!this._independenceTest.getTruthValue()) {
                    structure.addEdge(x, y);
                    blanket.set(y, true);
                }
                y = remainingNodes.nextSetBit(y + 1);
            }
            y = blanket.nextSetBit(x + 1);
            while (y >= 0) {
                blanket.set(y, false);
                contextualVariables = new ArrayList();
                contextualValues = new ArrayList();
                i = blanket.nextSetBit(0);
                while (i >= 0) {
                    contextualVariables.add(i);
                    contextualValues.add(context.getVal(i));
                    i = blanket.nextSetBit(i + 1);
                }
                this._independenceTest.independent(x, y, contextualVariables, contextualValues);
                ++this._countS;
                this._wcountS += (long)(2 + contextualVariables.size());
                if (this._independenceTest.getTruthValue()) {
                    structure.rmEdge(x, y);
                } else {
                    blanket.set(y, true);
                }
                y = blanket.nextSetBit(y + 1);
            }
        }
        return structure;
    }

    public Map<Structure, List<Feature>> execute(Collection<Feature> contexts) {
        HashMap<Structure, List<Feature>> structures = new HashMap<Structure, List<Feature>>();
        int i = 0;
        for (Feature context : contexts) {
            long startTime = System.currentTimeMillis();
            String strOutput = "(" + ++i + "/" + contexts.size() + ") " + context;
            Structure structure = this.csgs(context);
            List<Feature> contextsOfStructure = structures.containsKey(structure) ? (List)structures.get(structure) : new ArrayList();
            contextsOfStructure.add(context);
            structures.put(structure, contextsOfStructure);
            long totalTime = System.currentTimeMillis() - startTime;
            FileHandler.writeMessage(this._conf.getLogFile(), strOutput + " in " + totalTime + " ms.");
            FileHandler.writeNetwork(structure, context, this._conf.getNetworkFile());
        }
        return structures;
    }

    public long getCountG() {
        return this._countG;
    }

    public long getWcountG() {
        return this._wcountG;
    }

    public long getCountS() {
        return this._countS;
    }

    public long getWcountS() {
        return this._wcountS;
    }

    public long getCount() {
        return this._countG + this._countS;
    }

    public long getWcount() {
        return this._wcountG + this._wcountS;
    }
}

